﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using System.Reflection;

namespace AZVIC.Ei8htPOS.Utilities
{
    public static class GlobalConfigurations
    {

        public enum Mode
        {
            Insert = 1,
            Update = 2,
            Delete = 3,
            Select = 4,
            Search = 5
        }

        public static class AppConfiguration
        {

            //public static bool IsLocalDatabase = false;
            public static bool IsLocalDatabase
            {
                get
                {
                    return (!IsConnectedToInternet());
                }
            }

            public static string ConnectionString
            {
                get
                {
                    string connStr = string.Empty;
                    if (!IsLocalDatabase)
                    {
                        connStr = ConfigurationManager.ConnectionStrings[ConnectionStringName()].ConnectionString;
                        connStr = Encrypto.DecipherText(connStr);
                    }
                    else
                    {
                        connStr = ConfigurationManager.ConnectionStrings[OfflineConnectionStringName()].ConnectionString;
                        connStr = Encrypto.DecipherText(connStr);
                    }
                    return connStr;
                }
            }

            public static string LocalConnectionString()
            {
                string connStr = string.Empty;
                connStr = ConfigurationManager.ConnectionStrings[OfflineConnectionStringName()].ConnectionString;
                connStr = Encrypto.DecipherText(connStr);
                return connStr;
            }

            public static string CloudConnectionString()
            {
                string connStr = string.Empty;
                connStr = ConfigurationManager.ConnectionStrings[ConnectionStringName()].ConnectionString;
                connStr = Encrypto.DecipherText(connStr);
                return connStr;
            }


            /// <summary>Returns the name of the current connectionstring for the application.</summary>
            public static string ConnectionStringName()
            {
                return ConfigurationManager.AppSettings["Ei8htConnection"];
            }

            public static string OfflineConnectionStringName()
            {
                return ConfigurationManager.AppSettings["Ei8htOfflineConnection"];
            }

            [System.Runtime.InteropServices.DllImport("wininet.dll")]
            private extern static bool InternetGetConnectedState(out int Description, int ReservedValue);
            public static bool IsConnectedToInternet()
            {
                int Desc;
                return InternetGetConnectedState(out Desc, 0);
            }
            public static string GetExecutionPath()
            {
                return System.AppDomain.CurrentDomain.BaseDirectory;
            }
            public static string GetAppDataPath()
            {
                return Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData);
            }

            public static short ReceiptCount()
            {
                short Result;
                bool success = short.TryParse(ConfigurationManager.AppSettings["ReceiptPrintCount"], out Result);
                if (!success)
                    Result = 1;
                return Result;
            }
        }
    }
}
